function LWM_options = LWM_options_setup(varargin)

%==========================================================================================
%This function sets the options for the LWM_RND function.
%If no inputs are provided, the function returns all default options.
%
%The inputs of the function are the following string-value pair:
%   
%   objval_scale:   Multiplicative scale factor applied to objective function. Default = 1e3
%   Lmax:           Maximum number of times to draw initial starting vector. Default = 100
%   Smax:           Maximum number of optimal solutions found. Default = 5
%   Srun_max:       Maximum number of function optimizations run. Default = 50
%   c:              Lower bound for the ratio of the smallest mixture variance 
%                   to the largest mixture variance. Default = 0.0
%   Display:        set Display = 'off' suppresses all messages printed to
%                   the command window. Display = 'final' prints to the
%                   command window after every global estimation. 
%                   Display = 'iter' (default) prints to the command window 
%                   after every local estimation.
%   fval_ub:        Upper bound for the objective function value. Default = Inf
%==========================================================================================
% This ver: 2023/05/24
% Authors: Yifan Li (yifan.li@manchester.ac.uk)
%          Ingmar Nolte (i.nolte@lancaster.ac.uk)
%          Manh Pham (m.c.pham@lancaster.ac.uk)
% Reference: Li, Y., Nolte, I., and Pham, M. C. (2023). Parametric Risk-Neutral 
%          Density Estimation via Finite Lognormal-Weibull Mixtures
%========================================================================================== 


%Setting default options
LWM_options = struct;
LWM_options.objval_scale = 1e3;
LWM_options.Lmax = 100;
LWM_options.Smax = 5;
LWM_options.Srun_max = 50;
LWM_options.c = 0.0;
LWM_options.Display = 'iter';
LWM_options.fval_ub = Inf;


pvPairs = varargin;
optionlist={'objval_scale','Lmax','Smax','Srun_max','Display','slb','fval_ub'};
for i = 1:2:length(pvPairs)
    if ischar(pvPairs{i}) || (isstring(pvPairs{i}) && isscalar(pvPairs{i}))
        if ismember(pvPairs{i},optionlist)
            LWM_options.(pvPairs{i}) = pvPairs{i+1};
        else
            error('Option not supported.')
        end
    end
end
end

